DROP TABLE IF EXISTS `content_manager`;
CREATE TABLE `content_manager` (
	`content_id` int(11) NOT NULL AUTO_INCREMENT,
	`categories_id` int(11) NOT NULL DEFAULT '0',
	`parent_id` int(11) NOT NULL DEFAULT '0',
	`group_ids` text,
	`languages_id` int(11) NOT NULL DEFAULT '0',
	`content_version` varchar(255) NOT NULL DEFAULT '',
	`content_name` text NOT NULL,
	`content_title` text NOT NULL,
	`content_heading` text NOT NULL,
	`content_text` mediumtext NOT NULL,
	`sort_order` int(4) NOT NULL DEFAULT '0',
	`file_flag` int(1) NOT NULL DEFAULT '0',
	`content_file` varchar(64) NOT NULL DEFAULT '',
	`download_file` varchar(64) NOT NULL DEFAULT '',
	`content_status` int(1) NOT NULL DEFAULT '0',
	`content_group` int(11) NOT NULL DEFAULT '0',
	`content_delete` int(1) NOT NULL DEFAULT '1',
	`gm_link` text NOT NULL,
	`gm_link_target` varchar(10) NOT NULL DEFAULT '',
	`gm_priority` varchar(3) NOT NULL DEFAULT '0.5',
	`gm_changefreq` varchar(255) NOT NULL DEFAULT 'weekly',
	`gm_last_modified` timestamp NOT NULL ON UPDATE CURRENT_TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	`gm_sitemap_entry` int(1) NOT NULL DEFAULT '1',
	`gm_robots_entry` int(1) NOT NULL DEFAULT '0',
	`gm_url_keywords` varchar(255) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
	`contents_meta_title` text NOT NULL,
	`contents_meta_description` text NOT NULL,
	`contents_meta_keywords` text NOT NULL,
	`opengraph_image` VARCHAR(255) NULL DEFAULT NULL,
	`content_position` varchar(64) NOT NULL,
	`content_type` varchar(64) NOT NULL,
	`protected` varchar(64) NOT NULL DEFAULT '',
	PRIMARY KEY (`content_id`),
	KEY `languages_id` (`languages_id`,`file_flag`,`content_status`,`sort_order`),
	KEY `content_id` (`content_id`,`languages_id`),
	KEY `content_group` (`content_group`,`languages_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8;

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`, `contents_meta_title`, `contents_meta_description`, `contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Session interrupted (PayPal)', 'Loss of session', 'Your session has been interrupted', 'For PayPal payments to work as expected it is essential that your browser sends a session identification (session cookie) when returning from PayPal authorization. Your browser did not send this identification, therefore your shopping session has been terminated. Please deactivate any &ldquo;anti virus&rdquo; or &ldquo;internet security&ldquo; software you may be running on your computer. Afterwards, you can log in to the shop system again and continue your shopping experience.<br />\r\n&nbsp;', 0, 0, '', '', 1, 3300001, 1, '', '', '0.0', 'always', 0, 1, 'session-lost', '1', 'pages_info', 'content', '', '', ''),
	(0, 0, '', 2, 'Sitzungsunterbrechung (PayPal)', 'Sitzung unterbrochen', 'Die Sitzung wurde unterbrochen', 'F&uuml;r das korrekte Funktionieren der Zahlung &uuml;ber PayPal ist es notwendig, dass Ihr Browser bei der R&uuml;ckkehr in den Shop nach der PayPal-Autorisierung weiterhin die Kennung der zuvor verwendeten Sitzung (Session-Cookie) sendet. Dies erfolgt gegenw&auml;rtig nicht. Ein m&ouml;glicher Grund k&ouml;nnte die Verwendung von &bdquo;Antiviren&ldquo;-Software oder sonstiger &bdquo;Internet Security&ldquo;-Software sein. Bitte deaktivieren Sie daher derlei Einflussfaktoren. Anschlie&szlig;end k&ouml;nnen Sie sich erneut in den Shop einloggen und Ihren Einkauf fortsetzen.<br />\r\n&nbsp;', 0, 0, '', '', 1, 3300001, 1, '', '', '0.0', 'always', 0, 1, 'session-lost', '1', 'pages_info', 'content', '', '', '');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_last_modified`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Privacy Notice', 'Privacy Notice', 'Privacy Notice', '<p>Enter your Privacy Notice information here.</p>', 0, 1, '', '', 1, 2, 0, '', '_blank', '0.0', 'weekly', '2008-08-25 17:21:28', 0, 1, 'privacy-notice', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'General Terms & Conditions', 'General Terms & Conditions', 'General Terms & Conditions', '<p>The General Terms & Conditions (GTC) of a webshop provide the legal framework for all transactions, they are pre-formulated contract terms on the part of the shop-owner. Faulty GTC however, can prove to be hazardous for online merchants, as invalid or outdated clauses within the conditions are a frequent cause for cease-and-decist orders. And keeping the GTC up to date can be time-consuming and work-intensive.</p><p>We therefore recommend to implement the services of our legal partners, that offer to automatically update the important legal texts in your shop to keep you safe from any cease-and-decists:</p><p><a style="color: #0000EE;" href="https://www.it-recht-kanzlei.de/Service/gambio-agb-schnittstelle.php" title="GTC for Gambio-Shops by IT-Recht-Kanzlei" target="_blank">GTC for Gambio-Shops by IT-Recht-Kanzlei</a></p><p><a style="color: #0000EE;" href="http://www.janolaw.de/partner/gambio/index.html?partnerid=8604#menu" title="GTC for Gambio-Shops by Janolaw" target="_blank">GTC for Gambio-Shops by Janolaw</a></p><p>That way you can lean back and concentrate your efforts on what really counts: Your customers</p>', 0, 1, '', '', 1, 3, 0, '', '_blank', '0.0', 'weekly', '2008-08-25 17:21:47', 0, 1, 'conditions-of-use', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'Legal Information', 'Legal Information', 'Legal Information', '<p>This is the place for your legal information. Every webshop is required by law to display its complete legal information to allow customers quick and easy access to all the relevant data of the shop-owner, including name, address or contact info.</p><p>If you are unsure about the exact elements required in your legal information and how to correctly display them, we recommend to make use of the services of our legal partners. They offer quick and straighforward ways to compile professional legal information for your shop. You can also choose to have all the legal texts in your shop automatically updated for you by our partners, so that they are always kept in line with current jurisdiction.</p><p><a style="color: #0000EE;" href="https://www.it-recht-kanzlei.de/Service/gambio-agb-schnittstelle.php" title="Service for legal information by IT-Recht-Kanzlei" target="_blank">Service for legal information by IT-Recht-Kanzlei</a><p><p><a style="color: #0000EE;" href="http://www.janolaw.de/partner/gambio/index.html?partnerid=8604#menu" title="Service for legal information by Janolaw" target="_blank">Service for legal information by Janolaw</a></p>', 0, 1, '', '', 1, 4, 0, '', '_blank', '0.0', 'weekly', '2008-08-25 17:22:50', 0, 1, 'imprint', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'Index', 'Index', 'Welcome', '<h1>Welcome to your Shop</h1>\r\n<p>This Onlineshop was created with <a href="https://www.gambio.de"><strong>Gambio Shopsoftware</strong></a>.</p>\r\n<p>This text can be edited at Content Manager -&gt; Index in the backend.</p>', 0, 4, '', '', 1, 5, 0, '', '_blank', '0.0', 'always', '2011-03-16 16:28:26', 1, 0, '', 1, 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Privatsphäre und Datenschutz', 'Privatsphäre und Datenschutz', 'Privatsphäre und Datenschutz', '<p>F&uuml;gen Sie hier Ihre Informationen &uuml;ber Privatsph&auml;re und Datenschutz ein. Alternativ k&ouml;nnen Sie das Plugin <i>janolaw AGB-Hosting</i> nutzen und Ihre Datenschutzerkl&auml;rung mithilfe eines Online-Assistenten direkt zusammen mit AGB, Widerrufsbelehrung und Impressum erstellen. In nur wenigen Minuten haben Sie&nbsp;unter fachkundiger Anleitung die <strong>wichtigsten</strong> Dokumente f&uuml;r Ihren Shop <strong>individuell</strong> zusammengestellt.</p><p>Das Plugin sorgt&nbsp;daf&uuml;r, dass die Dokumente in Ihren Shop eingebunden und bei ver&auml;nderter Rechtslage <strong>automatisch aktualisiert</strong> werden. Dabei wird die aktuelle Widerrufsbelehrung zus&auml;tzlich auch in der <strong>E-Mail-Best&auml;tigung</strong> angezeigt, die Sie an Ihre Kunden verschicken. Zusammen mit&nbsp;der <strong>Abmahnkostenhaftung</strong> durch die janolaw AG sind Sie damit optimal vor Abmahnungen gesch&uuml;tzt. <a href="http://www.janolaw.de/internetrecht/agb/agb-hosting-service/gambio/?partnerid=8604#menu">Hier</a> k&ouml;nnen Sie den Service unseres Partners janolaw buchen.</p>', 3, 1, '', '', 1, 2, 0, '', '_blank', '0.0', 'weekly', '2008-08-26 19:59:30', 0, 1, 'privatsphaere-und-datenschutz', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'AGB', 'AGB', 'Allgemeine Geschäftsbedingungen', '<p>Die Allgemeinen Gesch&auml;ftsbedingungen (AGB) eines Onlineshops bilden den rechtlichen Rahmen f&uuml;r alle Gesch&auml;fte, sie sind vorformulierte Vertragsbedingungen seitens des Shopbetreibers. Fehlerhafte AGB sind aber auch immer wieder ein Stolperstein f&uuml;r Onlineh&auml;ndler, denn gerade ung&uuml;ltige oder veraltete Klauseln in den Gesch&auml;ftsbedingungen sind ein h&auml;ufiger Grund f&uuml;r Abmahnungen. Die eigenen AGB immer auf dem neuesten Stand zu halten kann zeitaufw&auml;ndig und arbeitsintensiv sein.</p><p>Wir empfehlen unseren Kunden, die AGB-Services unserer Rechtspartner in Anspruch zu nehmen, mit denen die wichtigsten Rechtstexte in Ihrem Shop automatisch aktualisiert werden und Sie keine Angst vor Abmahnungen haben m&uuml;ssen:</p><p><a style="color: #0000EE;" href="https://www.it-recht-kanzlei.de/Service/gambio-agb-schnittstelle.php" title="AGB f&uuml;r Gambio-Shops von der IT-Recht-Kanzlei" target="_blank">AGB f&uuml;r Gambio-Shops von der IT-Recht-Kanzlei</a></p><p><a style="color: #0000EE;" href="http://www.janolaw.de/partner/gambio/index.html?partnerid=8604#menu" title="AGB f&uuml;r Gambio-Shops von Janolaw" target="_blank">AGB f&uuml;r Gambio-Shops von Janolaw</a></p><p>So können Sie sich zur&uuml;cklehnen und sich auf das Wesentliche konzentrieren: Ihre Kunden.</p>', 1, 1, '', '', 1, 3, 0, '', '_blank', '0.0', 'weekly', '2012-01-30 14:45:57', 0, 1, 'allgemeine-geschaeftsbedingungen', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'Suchen', 'Suchen', '', '', 0, 3, '', '', 0, 30, 1, 'advanced_search.php', '_top', '0.0', 'always', '2008-07-30 04:24:06', 0, 0, '', 0, 'pages_main', 'link','','',''),
	(0, 0, '', 1, 'Search', 'Search', '', '', 0, 3, '', '', 0, 30, 1, 'advanced_search.php', '_top', '0.0', 'always', '2008-07-30 04:24:06', 0, 0, '', 0, 'pages_main', 'link','','',''),
	(0, 0, '', 2, 'Impressum', 'Impressum', 'Impressum', '<p>An dieser Stelle k&ouml;nnen Sie Ihr Impressum hinterlegen. Ein vollst&auml;ndiges Impressum ist f&uuml;r jeden Onlineshop rechtlich vorgeschrieben, es dient dazu, Kunden schnell und einfach Zugang zu den relevanten Informationen des Shopbetreibers zu erlauben. Dazu z&auml;hlen Name, Anschrift oder Kontaktdaten.</p><p>Wenn Sie sich nicht ganz sicher sind, welche Elemente in ein rechtssicheres Impressum geh&ouml;ren und wie diese genau dargestellt werden m&uuml;ssen, empfehlen wir Ihnen, die Dienste unserer Rechtspartner in Anspruch zu nehmen. Damit k&ouml;nnen Sie sich schnell und unkompliziert ein professionelles Impressum f&uuml;r Ihren Shop erstellen lassen, das sogar zusammen mit allen anderen Rechtstexten im Shop durch unsere Partner immer auf dem neuesten Stand der Rechtsprechung gehalten werden kann:</p><p><a style="color: #0000EE;" href="https://www.it-recht-kanzlei.de/Service/gambio-agb-schnittstelle.php" title="Impressumsservice der IT-Recht-Kanzlei" target="_blank">Impressumsservice der IT-Recht-Kanzlei</a></p><p><a style="color: #0000EE;" href="http://www.janolaw.de/partner/gambio/index.html?partnerid=8604#menu" title="Impressumsservice von Janolaw" target="_blank">Impressumsservice von Janolaw</a></p>', 0, 1, '', '', 1, 4, 0, '', '_top',   '0.0', 'weekly', '2008-07-29 18:01:46', 0, 1, 'impressum', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'Index', 'Index', 'Willkommen', '<h1>Herzlich willkommen in Ihrem Shop</h1>\r\n<p>Dieser Onlineshop wurde mit der <a href="https://www.gambio.de"><strong>Gambio Shopsoftware</strong></a> erstellt.</p>\r\n<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Index bearbeiten.</p>', 0, 4, '', '', 1, 5, 0, '', '_blank', '0.0', 'always', '2011-03-16 16:24:27', 1, 0, '', 1, 'elements_start', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 2, 'Gutscheine', 'Gutscheine', 'Gutscheine - Fragen und Antworten', '<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Gutscheine kaufen </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Gutscheine können, falls sie im Shop angeboten werden, wie normale Artikel gekauft werden. Sobald Sie einen Gutschein gekauft haben und dieser nach erfolgreicher Zahlung freigeschaltet wurde, erscheint der Betrag unter Ihrem Warenkorb. Nun können Sie über den Link " Gutschein versenden " den gewünschten Betrag per E-Mail versenden. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Wie man Gutscheine versendet </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Um einen Gutschein zu versenden, klicken Sie bitte auf den Link "Gutschein versenden" in Ihrem Einkaufskorb. Um einen Gutschein zu versenden, benötigen wir folgende Angaben von Ihnen: Vor- und Nachname des Empfängers. Eine gültige E-Mail Adresse des Empfängers. Den gewünschten Betrag (Sie können auch Teilbeträge Ihres Guthabens versenden). Eine kurze Nachricht an den Empfänger. Bitte überprüfen Sie Ihre Angaben noch einmal vor dem Versenden. Sie haben vor dem Versenden jederzeit die Möglichkeit Ihre Angaben zu korrigieren. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Mit Gutscheinen Einkaufen. </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Sobald Sie über ein Guthaben verfügen, können Sie dieses zum Bezahlen Ihrer Bestellung verwenden. Während des Bestellvorganges haben Sie die Möglichkeit Ihr Guthaben einzulösen. Falls das Guthaben unter dem Warenwert liegt müssen Sie Ihre bevorzugte Zahlungsweise für den Differenzbetrag wählen. Übersteigt Ihr Guthaben den Warenwert, steht Ihnen das Restguthaben selbstverständlich für Ihre nächste Bestellung zur Verfügung. </td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Gutscheine verbuchen. </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Wenn Sie einen Gutschein per E-Mail erhalten haben, können Sie den Betrag wie folgt verbuchen:. <br />1. Klicken Sie auf den in der E-Mail angegebenen Link. Falls Sie noch nicht über ein persönliches Kundenkonto verfügen, haben Sie die Möglichkeit ein Konto zu eröffnen. <br />2. Nachdem Sie ein Produkt in den Warenkorb gelegt haben, können Sie dort Ihren Gutscheincode eingeben.</td></tr></tbody></table>\r\n<table cellSpacing=0 cellPadding=0>\r\n<tbody>\r\n<tr>\r\n<td class=main><STRONG>Falls es zu Problemen kommen sollte: </STRONG></td></tr>\r\n<tr>\r\n<td class=main>Falls es wider Erwarten zu Problemen mit einem Gutschein kommen sollte, kontaktieren Sie uns bitte per E-Mail : you@yourdomain.com. Bitte beschreiben Sie möglichst genau das Problem, wichtige Angaben sind unter anderem: Ihre Kundennummer, der Gutscheincode, Fehlermeldungen des Systems sowie der von Ihnen benutzte Browser. </td></tr></tbody></table>', 0, 1, '', '', 0, 6, 0, '', '', '', '', 1, 0, '', 1, 'pages_info', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_last_modified`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Vouchers', 'Vouchers', 'Vouchers', '<p>Enter your Vouchers information here.</p>', 0, 1, '', '', 0, 6, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:23:24', 1, 0, '', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'Über uns', 'Über uns', 'Über uns', '<p>F&uuml;gen Sie hier Ihre Informationen &uuml;ber sich bzw. Ihr Unternehmen ein.</p>', 1, 3, '', '', 0, 82, 1, '', '_blank', '0.0', 'always', '2008-08-25 17:57:47', 0, 0, '', 0, 'pages_main', 'content','','',''),
	(0, 0, '', 1, 'About us', 'About us', 'About us', '<p>Fill in the informations about you or your corporation.</p>', 1, 3, '', '', 0, 82, 1, '', '_blank', '0.0', 'always', '2008-08-25 17:57:47', 0, 0, '', 0, 'pages_main', 'content','','',''),
	(0, 0, '', 2, 'Kontakt', 'Kontakt', 'Kontakt', '<p>F&uuml;gen Sie hier Ihre Kontaktinformationen ein.</p>', 0, 1, '', '', 1, 7, 0, '', '_blank', '0.0', 'always', '2008-08-26 20:00:45', 1, 0, 'mein-kontakt', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'Contact', 'Contact', 'Contact', '<p>Enter your Contact information here.</p>', 0, 1, '', '', 1, 7, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:23:42', 1, 0, 'contact', 1, 'pages_info', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Sitemap', 'Sitemap', '', '', 0, 0, 'sitemap.php', '', 1, 8, 0, '', '', '', '', 1, 0, 'sitemap', 1, 'pages_info_box', 'file','','',''),
	(0, 0, '', 2, 'Sitemap', 'Sitemap', 'Sitemap', '', 0, 0, 'sitemap.php', '', 1, 8, 0, '', '_blank', '', '', 1, 0, 'sitemap', 1, 'pages_info_box', 'file','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_last_modified`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Callback Service', 'Callback Service', 'Callback Service', '<p>This text can be edited at Content Manager -&gt; Pages -&gt; Info pages -&gt; Callback Service in the backend.</p>', 5, 1, 'gm_callback_service.php', '', 1, 14, 0, '', '_blank', '0.0', 'always', '2008-08-26 20:02:29', 1, 0, 'callback-service', 1, 'pages_info', 'file','','',''),
	(0, 0, '', 2, 'Callback Service', 'Callback Service', 'Callback Service', '<p>Den Inhalt dieses Bereiches k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Seiten -&gt; Infoseiten -&gt; Callback Service bearbeiten.</p>', 5, 1, 'gm_callback_service.php', '', 1, 14, 0, '', '_blank', '0.0', 'always', '2008-08-26 20:02:29', 1, 0, 'callback-service', 1, 'pages_info', 'file','','',''),
	(0, 0, '', 2, 'Zusatzbox 1', 'Zusatzbox 1', 'Zusatzbox 1', '<p style="text-align: center;"><a href="http://validator.w3.org/check?uri=referer"><img height="31" width="88" alt="Valid XHTML 1.0 Transitional" src="https://www.w3.org/Icons/valid-xhtml10" /></a></p>', 0, 4, '', '', 0, 61, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:45:27', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 2', 'Zusatzbox 2', 'Zusatzbox 2 Titel', '<p>Zusatzbox 2 Inhalt</p>\r\n<br />', 0, 4, '', '', 0, 62, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:10', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 3', 'Zusatzbox 3', 'Zusatzbox 3 Titel', '<p>Zusatzbox 3 Inhalt</p>', 0, 4, '', '', 0, 63, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:17', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 4', 'Zusatzbox 4', 'Zusatzbox 4 Titel', '<p>Zusatzbox 4 Inhalt</p>', 0, 4, '', '', 0, 64, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:22', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 5', 'Zusatzbox 5', 'Zusatzbox 5 Titel', '<p>Zusatzbox 5 Inhalt</p>', 0, 4, '', '', 0, 65, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:29', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 6', 'Zusatzbox 6', 'Zusatzbox 6 Titel', '<p>Zusatzbox 6 Inhalt</p>', 0, 4, '', '', 0, 66, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:35', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 7', 'Zusatzbox 7', 'Zusatzbox 7 Titel', '<p>Zusatzbox 7 Inhalt</p>', 0, 4, '', '', 0, 67, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:41', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 8', 'Zusatzbox 8', 'Zusatzbox 8 Titel', '<p>Zusatzbox 8 Inhalt</p>', 0, 4, '', '', 0, 68, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:16:50', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 2, 'Zusatzbox 9', 'Zusatzbox 9', 'Zusatzbox 9 Titel', '<p>Zusatzbox 9 Inhalt</p>', 0, 4, '', '', 0, 69, 0, '', '_blank', '0.0', 'always', '2008-08-25 17:17:00', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 1', 'Extrabox 1', 'Extrabox 1 Title', '<a href="http://validator.w3.org/check?uri=referer"><img src="https://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0 Transitional" height="31" width="88" /></a>', 0, 4, '', '', 0, 61, 0, '', '_blank', '0.0', 'always', '2008-08-15 09:24:18', 0, 0, '', 1, 'elements_boxes', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Extrabox 2', 'Extrabox 2', 'Extrabox 2 Title', 'Content Extrabox 2', 0, 4, '', '', 0, 62, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 3', 'Extrabox 3', 'Extrabox 3 Title', 'Content Extrabox 3', 0, 4, '', '', 0, 63, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 4', 'Extrabox 4', 'Extrabox 4 Title', 'Content Extrabox 4', 0, 4, '', '', 0, 64, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 5', 'Extrabox 5', 'Extrabox 5 Title', 'Content Extrabox 5', 0, 4, '', '', 0, 65, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 6', 'Extrabox 6', 'Extrabox 6 Title', 'Content Extrabox 6', 0, 4, '', '', 0, 66, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 7', 'Extrabox 7', 'Extrabox 7 Title', 'Content Extrabox 7', 0, 4, '', '', 0, 67, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 8', 'Extrabox 8', 'Extrabox 8 Title', 'Content Extrabox 8', 0, 4, '', '', 0, 68, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Extrabox 9', 'Extrabox 9', 'Extrabox 9 Title', 'Content Extrabox 9', 0, 4, '', '', 0, 69, 0, '', '', '', '', 0, 0, '', 1, 'elements_boxes', 'content','','',''),
	(0, 0, '', 1, 'Header', 'Header', '', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Header -&gt; Header in the backend.</p>', 0, 4, '', '', 1, 4321001, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_header', 'content','','',''),
	(0, 0, '', 2, 'Header', 'Header', '', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Header -&gt; Header bearbeiten.</p>', 0, 4, '', '', 1, 4321001, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_header', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_last_modified`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Index (center)', 'Index (center)', '', '', 0, 4, '', '', 0, 10, 0, '', '_blank', '0.0', 'always', '2008-07-29 18:04:53', 0, 0, '', 1, 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Index (Mitte)', 'Index (Mitte)', '', '', 0, 4, '', '', 0, 10, 0, '', '_blank', '0.0', 'always', '2008-07-29 18:03:44', 0, 0, '', 1, 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Index (bottom)', 'Index (bottom)', '', '', 0, 4, '', '', 0, 11, 0, '', '_blank', '0.0', 'always', '2008-07-29 18:04:53', 0, 0, '', 1, 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Index (unten)', 'Index (unten)', '', '', 0, 4, '', '', 0, 11, 0, '', '_blank', '0.0', 'always', '2008-07-29 18:03:44', 0, 0, '', 1, 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Footer Header', 'Footer Header', '', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Footer -&gt; Footer Header in the backend.</p>', 0, 4, '', '', 1, 199, 0, '', '_blank', '0.0', 'always', '2011-03-17 11:39:53', 0, 0, '', 1, 'elements_footer', 'content','','',''),
	(0, 0, '', 2, 'Footer Kopfzeile', 'Footer Kopfzeile', '', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Footer -&gt; Footer Kopfzeile bearbeiten.</p>', 0, 4, '', '', 1, 199, 0, '', '_blank', '0.0', 'always', '2011-03-17 11:39:26', 0, 0, '', 1, 'elements_footer', 'content','','',''),
	(0, 0, '', 1, 'Checkout confirmation information', 'Checkout confirmation information', '', '', 0, 4, '', '', 1, 198, 0, '', '_blank', '0.0', 'always', '2011-03-17 11:39:53', 0, 0, '', 1, 'elements_others', 'content','','',''),
	(0, 0, '', 2, 'Bestellzusammenfassung Information', 'Bestellzusammenfassung Information', '', '', 0, 4, '', '', 1, 198, 0, '', '_blank', '0.0', 'always', '2011-03-17 11:39:26', 0, 0, '', 1, 'elements_others', 'content','','',''),
	(0, 0, '', 1, 'Shipping & payment conditions', 'Shipping & payment conditions', 'Shipping & payment conditions', 'Enter your information about shipping and payment conditions here. <br /><br />{$shipping_and_payment_matrix}<br /><br />{$klarna_hub_terms_and_conditions}<br />', 0, 1, '', '', 1, 3889891, 0, '', '_blank', '1.0', 'weekly', '2014-06-10 13:46:44', 0, 1, 'Shipping-and-payment-conditions', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'Versand- & Zahlungsbedingungen', 'Versand- & Zahlungsbedingungen', 'Versand- & Zahlungsbedingungen', 'F&uuml;gen Sie hier Ihre Informationen zu Versand- &amp; Zahlungsbedingungen ein. <br /><br />{$shipping_and_payment_matrix}<br /><br />{$klarna_hub_terms_and_conditions}<br />', 0, 1, '', '', 1, 3889891, 0, '', '_blank', '1.0', 'weekly', '2014-06-10 13:46:44', 0, 1, 'Versand-und-Zahlungsbedingungen', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'Right of Withdrawal / Model Withdrawal Form', 'Right of Withdrawal / Model Withdrawal Form', 'Right of Withdrawal / Model Withdrawal Form', '<img alt="" src="templates/Honeygrid/assets/images/icon_arrow.gif" style="margin-bottom:2px" /> <a href="{$PAGE_URL}#withdrawal_rights"><u>Right of Withdrawal</u></a> <br />\r\n<br />\r\n<img alt="" src="templates/Honeygrid/assets/images/icon_arrow.gif" style="margin-bottom:2px" /> <a href="{$PAGE_URL}#withdrawal_form"><u>Model Withdrawal Form</u></a> <br />\r\n<br />\r\n<br />\r\n<h2><a name="withdrawal_rights"></a>Right of Withdrawal <span style="font-size: 13px; font-weight: normal;">(<a href="{$PDF_URL}"><u>Download as PDF</u></a>)</span></h2>\r\n<span>{$WITHDRAWAL_TEXT}</span><br />\r\n<br />\r\n<br />\r\n{* withdrawal_form_start *}\r\n<h2><a name="withdrawal_form"></a>Model Withdrawal Form</h2>\r\n{* withdrawal_pdf_link_start *}<span>Our model withdrawal form as PDF document: <a href="{$PDF_FORM_URL}"><u>DOWNLOAD</u></a></span><br />\r\n{* withdrawal_pdf_link_end *} {* withdrawal_form_link_start *}<span>Our online model withdrawal form: <a href="{$WEBFORM_URL}"><u>ONLINE-FORM</u></a></span><br />\r\n{* withdrawal_form_link_end *} <br />\r\n<br />\r\n{* withdrawal_form_end *}<span><em>To open the downloadable PDF-files, you need an additional program such as the Adobe Reader, which you can download online for free. The current version of the Adobe Reader you can find <a href="http://get.adobe.com/uk/reader/" target="_blank"><u>here</u></a>.</em></span><br />\r\n<br />', 0, 1, '', '', 1, 3889895, 0, '', '_blank', '1.0', 'weekly', '2008-08-26 20:02:53', 0, 1, 'Right-of-Withdrawal--Model-Withdrawal-Form', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 2, 'Widerrufsrecht & Muster-Widerrufsformular', 'Widerrufsrecht & Muster-Widerrufsformular', 'Widerrufsrecht & Muster-Widerrufsformular', '<img style="margin-bottom:2px" src="templates/Honeygrid/assets/images/icon_arrow.gif" alt="" /> <a href="{$PAGE_URL}#withdrawal_rights"><u>Widerrufsrecht</u></a> <br />\r\n<br />\r\n<img style="margin-bottom:2px" src="templates/Honeygrid/assets/images/icon_arrow.gif" alt="" /> <a href="{$PAGE_URL}#withdrawal_form"><u>Muster-Widerrufsformular</u></a> <br />\r\n<br />\r\n<br />\r\n<h2><a name="withdrawal_rights"></a>Widerrufsrecht <span style="font-size: 13px; font-weight: normal;">(<a href="{$PDF_URL}"><u>Als PDF downloaden</u></a>)</span></h2>\r\n<span>{$WITHDRAWAL_TEXT}</span><br />\r\n<br />\r\n<br />\r\n{* withdrawal_form_start *}\r\n<h2><a name="withdrawal_form"></a>Muster-Widerrufsformular</h2>\r\n{* withdrawal_pdf_link_start *}<span>Unser Muster-Widerrufsformular im PDF-Format: <a href="{$PDF_FORM_URL}"><u>DOWNLOAD</u></a></span><br />\r\n{* withdrawal_pdf_link_end *} {* withdrawal_form_link_start *}<span>Unser Muster-Widerrufsformular zum online Ausf&uuml;llen: <a href="{$WEBFORM_URL}"><u>ONLINE-FORMULAR</u></a></span><br />\r\n{* withdrawal_form_link_end *} <br />\r\n<br />\r\n{* withdrawal_form_end *}<span><em>Um die zum Download angebotenen PDF-Dateien zu &ouml;ffnen, ben&ouml;tigen Sie ein Zusatzprogramm, wie zum Beispiel den Adobe Reader, welchen Sie im Internet kostenfrei herunterladen k&ouml;nnen. Die aktuelle Version des Adobe Readers finden Sie <a href="http://get.adobe.com/de/reader/" target="_blank"><u>hier</u></a>.</em></span><br />\r\n<br />', 0, 1, '', '', 1, 3889895, 0, '', '_blank', '1.0', 'weekly', '2008-08-26 20:02:53', 0, 1, 'Widerrufsrecht-und-Muster-Widerrufsformular', 1, 'pages_info', 'content','','',''),
	(0, 0, '', 1, 'Withdrawal 1', 'Withdrawal 1', 'Withdrawal 1', '<p>Enter your Withdrawal information here.</p>', 1, 5, '', '', 1, 3889896, 0, '', '_blank', '1.0', 'never', '2014-07-03 12:12:50', 0, 0, '', '1', 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 1, 'Withdrawal 2', 'Withdrawal 2', 'Withdrawal 2', 'Withdrawal 2 content', 2, 5, '', '', 0, 3889897, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 1, 'Withdrawal 3', 'Withdrawal 3', 'Withdrawal 3', 'Withdrawal 3 content', 3, 5, '', '', 0, 3889898, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 1, 'Withdrawal 4', 'Withdrawal 4', 'Withdrawal 4', 'Withdrawal 4 content', 4, 5, '', '', 0, 3889899, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 2, 'Widerrufsrecht 1', 'Widerrufsrecht 1', 'Widerrufsrecht 1', '<p>F&uuml;gen Sie hier Ihre Hinweise zum Widerrufsrecht ein. Alternativ k&ouml;nnen Sie das Plugin <em>janolaw AGB-Hosting</em> nutzen und Ihre Widerrufsbelehrung mithilfe eines Online-Assistenten direkt zusammen mit AGB, Datenschutzerkl&auml;rung und Impressum erstellen. In nur wenigen Minuten haben Sie&nbsp;unter fachkundiger Anleitung die <strong>wichtigsten</strong> Dokumente f&uuml;r Ihren Shop <strong>individuell </strong>zusammengestellt.</p>\r\n\r\n<p>Das Plugin sorgt&nbsp;daf&uuml;r, dass die Dokumente in Ihren Shop eingebunden und bei ver&auml;nderter Rechtslage <strong>automatisch aktualisiert</strong> werden. Dabei wird die aktuelle Widerrufsbelehrung zus&auml;tzlich auch in der <strong>E-Mail-Best&auml;tigung</strong> angezeigt, die Sie an Ihre Kunden verschicken. Zusammen mit der <strong>Abmahnkostenhaftung</strong> durch die janolaw AG sind Sie damit optimal vor Abmahnungen gesch&uuml;tzt. <a href="http://www.janolaw.de/internetrecht/agb/agb-hosting-service/gambio/?partnerid=8604#menu">Hier</a> k&ouml;nnen Sie den Service unseres Partners janolaw buchen.</p>', 1, 5, '', '', 1, 3889896, 0, '', '_blank', '1.0', 'never', '2014-07-03 12:11:43', 0, 0, '', '1', 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 2, 'Widerrufsrecht 2', 'Widerrufsrecht 2', 'Widerrufsrecht 2', 'Widerrufsrecht 2 Inhalt', 2, 5, '', '', 0, 3889897, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 2, 'Widerrufsrecht 3', 'Widerrufsrecht 3', 'Widerrufsrecht 3', 'Widerrufsrecht 3 Inhalt', 3, 5, '', '', 0, 3889898, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','',''),
	(0, 0, '', 2, 'Widerrufsrecht 4', 'Widerrufsrecht 4', 'Widerrufsrecht 4', 'Widerrufsrecht 4 Inhalt', 4, 5, '', '', 0, 3889899, 0, '', '_blank', '1.0', 'never', '2014-06-10 13:46:44', 0, 0, '', 1, 'elements_withdrawal', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Free Content 1', 'Free Content 1', '', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Homepage -&gt; Free Content 1 in the backend.</p>', 0, 4, '', '', 1, 4321002, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Free Content 1 (Malibu)', 'Free Content 1 (Malibu)', '', '<div class="row"><div class="col-xs-6 col-md-12"><a class="teaser" href="#"><img alt="" class="img-responsive" src="images/next-to-slider-content-1.png" /> </a> </div> <div class="col-xs-6 col-md-12"> <a class="teaser" href="#"><img alt="" class="img-responsive" src="images/next-to-slider-content-2.png" /> </a> </div></div>', 0, 4, '', '', 1, 4321008, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Free Content 2', 'Free Content 2', '', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Homepage -&gt; Free Content 2 in the backend.</p>', 0, 4, '', '', 1, 4321003, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Free Content 3', 'Free Content 3', '', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Homepage -&gt; Free Content 3 in the backend.</p>', 0, 4, '', '', 1, 4321004, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Freier Inhalt 1', 'Freier Inhalt 1', '', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Startseite -&gt; Freier Content 1 bearbeiten.</p>', 0, 4, '', '', 1, 4321002, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Freier Inhalt 1 (Malibu)', 'Freier Inhalt 1 (Malibu)', '', '<div class="row"><div class="col-xs-6 col-md-12"><a class="teaser" href="#"><img alt="" class="img-responsive" src="images/next-to-slider-content-1.png" /> </a> </div> <div class="col-xs-6 col-md-12"> <a class="teaser" href="#"><img alt="" class="img-responsive" src="images/next-to-slider-content-2.png" /> </a> </div></div>', 0, 4, '', '', 1, 4321008, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Freier Inhalt 2', 'Freier Inhalt 2', '', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Startseite -&gt; Freier Content 2 bearbeiten.</p>', 0, 4, '', '', 1, 4321003, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 2, 'Freier Inhalt 3', 'Freier Inhalt 3', '', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Startseite -&gt; Freier Content 3 bearbeiten.</p>', 0, 4, '', '', 1, 4321004, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_start', 'content','','',''),
	(0, 0, '', 1, 'Footer column 2', 'Footer column 2', 'Footer column 2', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Footer -&gt; Footer column 2 in the backend.</p>', 0, 4, '', '', 1, 4321005, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 1, 'Footer column 3', 'Footer column 3', 'Footer column 3', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Footer -&gt; Footer column 3 in the backend.</p>', 0, 4, '', '', 1, 4321006, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 1, 'Footer column 4', 'Footer column 4', 'Footer column 4', '<p>This text can be edited at Content Manager -&gt; Elements -&gt; Footer -&gt; Footer column 4 in the backend.</p>', 0, 4, '', '', 1, 4321007, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 2, 'Footer 2. Spalte', 'Footer Spalte 2', 'Footer Spalte 2', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Footer -&gt; Footer Spalte 2 bearbeiten.</p>', 0, 4, '', '', 1, 4321005, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 2, 'Footer Spalte 3', 'Footer Spalte 3', 'Footer Spalte 3', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Footer -&gt; Footer Spalte 3 bearbeiten.</p>', 0, 4, '', '', 1, 4321006, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 2, 'Footer Spalte 4', 'Footer Spalte 4', 'Footer Spalte 4', '<p>Diesen Text k&ouml;nnen Sie im Gambio Admin unter Content Manager -&gt; Elemente -&gt; Footer -&gt; Footer Spalte 4 bearbeiten.</p>', 0, 4, '', '', 1, 4321007, 0, '', '', '0.5', 'weekly', 0, 0, '', '1', 'elements_footer', 'content','','',''),
	(0, 0, '', 2, 'Datenweitergabe an Transportunternehmen', 'Datenweitergabe an Transportunternehmen', 'Datenweitergabe an Transportunternehmen', 'Meine E-Mail-Adresse und Telefonnummer darf zwecks meiner Information &uuml;ber den Versandstatus meiner Bestellung an das Transportunternehmen ({$VERSANDART_NAME}) weitergegeben werden.', 0, 1, '', '', 0, 3210123, 0, '', '', '0.5', 'weekly', 0, 0, '', 1, 'elements_others', 'content','','','');

INSERT INTO `content_manager` (`categories_id`, `parent_id`, `group_ids`, `languages_id`, `content_name`, `content_title`, `content_heading`, `content_text`, `sort_order`, `file_flag`, `content_file`, `download_file`, `content_status`, `content_group`, `content_delete`, `gm_link`, `gm_link_target`, `gm_priority`, `gm_changefreq`, `gm_sitemap_entry`, `gm_robots_entry`, `gm_url_keywords`, `protected`, `content_position`, `content_type`,`contents_meta_title`,`contents_meta_description`,`contents_meta_keywords`) VALUES
	(0, 0, '', 1, 'Data transfer to carriers', 'Data transfer to carriers', 'Data transfer to carriers', 'My email address and telephone number may be passed on to the carrier ({$VERSANDART_NAME}) so I can receive information about the shipping status of my order.', 0, 1, '', '', 0, 3210123, 0, '', '', '0.5', 'weekly', 0, 0, '', 1, 'elements_others', 'content','','','');
